//=============================================================================
// Total redo of the MSDriving1_2 Mod, free from MP replication shitstorms,
//    ~WCCC
//=============================================================================
class MSGunship extends Vehicles;

#exec AUDIO IMPORT FILE="Sounds\Thrusters.wav" NAME="Thrusters" GROUP="Ambient"
#exec AUDIO IMPORT FILE="Sounds\Hovercraft.wav" NAME="Hovercraft" GROUP="Ambient"
#exec AUDIO IMPORT FILE="Sounds\CannonFire.wav" NAME="CannonFire" GROUP="Ambient"
#exec AUDIO IMPORT FILE="Sounds\LaserFire.wav" NAME="LaserFire" GROUP="Ambient"

var DeusExPlayer Pilot;
var int VehicleSpeed;
var float VelocityMult, SpeedMult;
var float LastFly;
var Vector CockpitOffset;
var Sound ThrustSound, FallingSound;
var GunshipControl ControlStick;

var String ModeTypes[20];
var int NumberOfModes;

var Vector MissileOffset, CannonOffset, ArtilleryOffset, LaserOffset, BombOffset;
var HealthSprite HealthSprite;

var float Accelerator;

var Vector LastVel;
var bool bReverse;

function FireMissiles()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipRocket', Self,,Location + (MissileOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipRocket', Self,,Location + (MissileOffset * vect(1,-1,1) >> Rotation), Rotation);

 P.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
 P2.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
}

function FireCannons()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipRound', Self,,Location + (CannonOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipRound', Self,,Location + (CannonOffset * vect(1,-1,1) >> Rotation), Rotation);

 P.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
 P2.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
}

function FireArtillery()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipShell', Self,,Location + (ArtilleryOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipShell', Self,,Location + (ArtilleryOffset * vect(1,-1,1) >> Rotation), Rotation);

 P.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
 P2.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
}

function FireLasers()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipLaser', Self,,Location + (LaserOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipLaser', Self,,Location + (LaserOffset * vect(1,-1,1) >> Rotation), Rotation);

 P.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
 P2.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
}

function DropBombs()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipBomb', Self,,Location + (BombOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipBomb', Self,,Location + (BombOffset * vect(1,-1,1) >> Rotation), Rotation);
}


function Frob(Actor Frobber, Inventory frobWith)
{
  local DeusExPlayer player;

  player = DeusExPlayer(Frobber);

  if ((player != None) && (Pilot == None))
  {
    SetTimer(0.02, True);
    Pilot = player;
    SetSpecialPhysics(True);
    GiveControls(Player);
    Player.ReducedDamageType = 'All';
    return;
  }
  if ((player != None) && (Pilot != None))
  {
    Pilot.SetLocation(Self.Location + vect(0,0,1) * (CollisionHeight / 2 + Pilot.CollisionHeight + 48)); 
    Pilot.StartWalk();
    SetTimer(0, False);
    Pilot = None; 
    SetSpecialPhysics(False);
    DestroyControls();
    Player.ReducedDamageType = 'None';
    return;
  }
}

function GiveControls(DeusExPlayer P)
{
 local int i;
 
 ControlStick = Spawn(class'GunshipControl',None,,Location);
 ControlStick.Frob(P, None);
 ControlStick.Master = Self;
 ControlStick.NumModes = NumberOfModes;
 
 for(i=0; i<NumberOfModes + 1; i++)
 {
  ControlStick.ModeNames[i] = ModeTypes[i];
 }
 
 ControlStick.CurrentMode = ModeTypes[0];
 ControlStick.AdjustStats();
 
 //P.SetInHand(ControlStick);
}

function DestroyControls()
{
 ControlStick.Destroy();
}

function SetSpecialPhysics(bool B)
{
 if (B)
 {
  Mesh = None;
  SetPhysics(PHYS_Projectile);
  SetCollision(True, True, False);
  bCollideWorld = True;
  bBlockPlayers = False;
  bHighlight = False;
  AmbientSound = ThrustSound;
 }
 if (!B)
 {
  Mesh = Default.Mesh;
  SetPhysics(PHYS_Falling);
  bBlockPlayers = True;
  bCollideWorld = True;
  SetCollision(True, True, True);
  SetRotation(Rot(0,0,0));
  AmbientSound = None;
  bHighlight = True;
 }
}

function Landed(Vector H)
{
 if (Pilot == None) Super.Landed(H);
 
 if (Pilot != None)
 {
  SetLocation(Location + vect(0,0,5));
 }
}

function UpdateHealthSprite()
{
 //if (HealthSprite == None) SpawnHealthSprite();
 
 //HealthSprite.SetLocation(Location + (CockpitOffset * vect(-1,0,0) >> Rotation));
 //HealthSprite.UpdateTexture(hitPoints, Default.HitPoints);
}

/*function SpawnHealthSprite()
{
 HealthSprite = Spawn(class'HealthSprite', Self);
 HealthSprite.SetTimer(0.02, True);
}*/

function Timer()
{
 local Vector TempVect, TempVel;
 local Rotator TempRot, TempRot2; 
 local int Yaw1, Yaw2, YawDif;

 local int TempInt;
 

  /*if (Accelerator < 0.25) Accelerator = 0.25;
  if (Accelerator > 1) Accelerator = 1;*/

 UpdateHealthSprite();
 
 if (hitPoints < Default.hitPoints)
 {
  hitPoints++;
  ResetScaleGlow();
 }
 
 SetPhysics(PHYS_Projectile);
 
 if (Pilot != None) if (Pilot.InHand != ControlStick) Pilot.PutInHand(ControlStick);
 
 TempInt = 1;
 if (Pilot.Acceleration.X < 0) TempInt = -1;
 if (Pilot.bDuck == 1) TempInt = 0;
 
 TempRot = rot(0,0,0);
 TempRot.Pitch = Rotation.Pitch * TempInt;
 
 if (Pilot != None)
 {
  TempVel = (Pilot.Acceleration >> TempRot) * VelocityMult * vehiclespeed * Accelerator;
 
 //Yes Duck
 if (Pilot.bDuck == 1) TempVel += vect(0,0,1) * VehicleSpeed * SpeedMult;
 
 //calculate direction, eliminate roll
 TempVect = Vector(Pilot.ViewRotation);
 TempRot = Rotator(TempVect);
 TempRot2 = Rotator(Pilot.Acceleration);
 
 Yaw1 = ABS(TempRot.Yaw);
 Yaw2 = ABS(TempRot2.Yaw);
 
 YawDif = ABS(Yaw1 - Yaw2);
 
 bReverse = False;
 
 if (YawDif > 16384)
 {
  bReverse = True;
  //BroadcastMessage("Backwards!");
 }
 
 //if (bReverse) TempVel.Z *= -1;
 
 Pilot.SetLocation(Location + (CockpitOffset >> Rotation));
 Pilot.SetPhysics(PHYS_None);
 Pilot.Landed(Vect(0,0,0));
 }
 
 if (VSize(Velocity) < 20)
 {  
 }
 if (VSize(Velocity * vect(1,1,0)) > 20)
 {
 }
 
 SoundVolume = 255 * Accelerator;
 SoundRadius = 255 * Accelerator;
 
 if (VSize(Pilot.Acceleration * vect(1,1,0)) > 20)
 {
  LastFly = 0;
  Accelerator += 0.0125;
  if (Accelerator > 1) Accelerator = 1;

  LastVel = TempVel / Accelerator;
 }
 if (VSize(Pilot.Acceleration) < 20)
 {
  LastFly += 0.05;
  Accelerator -= 0.025;
  if (Accelerator < 0.0) Accelerator = 0.0;

  TempVel = LastVel * Accelerator;
 }

 if (Pilot != None) SetRotation(Pilot.ViewRotation);
 Acceleration = TempVel;
 Velocity = TempVel;
}

event Destroyed()
{
    //Pilot.SetLocation(Self.Location + vect(0,0,1) * (CollisionHeight / 2 + Pilot.CollisionHeight + 48)); 
    Pilot.StartWalk();
    Pilot.ReducedDamageType = 'None';
    Pilot = None;
    DestroyControls();


 Super.Destroyed();
}


function Bump(actor Other)
{
	local DeusExWeapon dxWeapon;
	local DeusExPlayer dxPlayer;
	local float        damage;

	Super.Bump(Other);

	if (Pilot != None && (Other != None) && (Other != Pilot))
	{
		// damage both of the player's legs if the karkian "charges"
		// just use Shot damage since we don't have a special damage type for charged
		// impart a lot of momentum, also
		if (VSize(Velocity) > 100)
		{
			damage = VSize(Velocity) / 5;
			Other.TakeDamage(damage, Pilot, Other.Location, 100*Velocity, 'Shot');
			dxPlayer = DeusExPlayer(Other);
			if (dxPlayer != None)
				dxPlayer.ShakeView(0.15 + 0.002*damage*2, damage*30*2, 0.3*damage*2);
		}
	}
}


defaultproperties
{
     SpeedMult=200
     VelocityMult=0.25
     VehicleSpeed=3
     bCanBeBase=True
     bBlockActors=True
     CockpitOffset=(X=-8.000000,Y=0.000000,Z=0.000000)
     SoundRadius=16
     SoundVolume=96
     AmbientSound=None
     ThrustSound=Sound'Thrusters'
     FallingSound=Sound'Hovercraft'
     bInvincible=False
     hitPoints=500
     fragType=class'MetalFragment'
     bExplosive=True
     ExplosionDamage=500
     ExplosionRadius=256
     bBlockSight=False
     bVisionImportant=True
}
